@echo off
setlocal enabledelayedexpansion
chcp 65001 > nul

:: 先将IP去重
set "inputFile=45102-1-443.txt"
set "tempFile=%temp%\IP_temp.txt"

if not exist "%inputFile%" (
    echo 文件 %inputFile% 不存在！
    pause
    exit /b
)

break > "%tempFile%"
set "totalCount=0"
set "duplicateCount=0"

for /f "usebackq delims=" %%a in ("%inputFile%") do (
    set "line=%%a"
    set "line=!line: =!"  :: 移除行内现有空格（如果需要）
    if "!line!" neq "" (
        set /a "totalCount+=1"
        if not defined _ip_!line! (
            >> "%tempFile%" echo(!line!
            set "_ip_!line!=1"
        ) else (
            set /a "duplicateCount+=1"
            echo 发现重复IP: !line!
        )
    )
)

move /y "%tempFile%" "%inputFile%" >nul
set /a "uniqueCount=totalCount - duplicateCount"

echo.
echo ====== 去重完成 ======
echo 总IP数量    : !totalCount!
echo 重复IP数量  : !duplicateCount!
echo 唯一IP数量  : !uniqueCount!
echo =====================
echo 结果已保存到 %inputFile%


::下上是压缩文件
set "source=45102-1-443.txt"
set "zipfile=txt.zip"

if not exist "%source%" (
    echo 错误：文件 "%source%" 不存在！
    pause
    exit /b
)

echo 正在压缩 "%source%" 到 "%zipfile%"...
powershell -command "Compress-Archive -Path '%source%' -DestinationPath '%zipfile%' -Force"

if exist "%zipfile%" (
    echo 压缩成功！"%zipfile%" 已更新。
) else (
    echo 压缩失败！
)

::pause